#ifndef __COMMON_H__
#define	__COMMON_H__

#include <sys/types.h>
#include <unistd.h>

typedef struct{
    int		hash;
    size_t	length;
    const char	*string;
} hstring;

int  hash_string(const char *ptr, size_t length);
int  hstring_cmp(hstring *hs1, hstring *hs2);
int  hash_stringcase(const char *ptr, size_t length);
int  hstring_casecmp(hstring *hs1, hstring *hs2);

void make_hstring(hstring *hs, const char *ptr, size_t length);
void make_casehstring(hstring *hs, const char *ptr, size_t length);

const char* filename_begin(const char *path);
const char* filename_end(const char *path);
size_t      filename_len(const char *path);
const char* next_filename(const char *path);

int  SetLogFile(char *filename);
int  SetUpdateTimeDelta(int delta);
int  GetUpdateTimeDelta();
int  SetSMBNetFsDebugLevel(int level);
int  GetSMBNetFsDebugLevel();

void safe_copy(char *dst, const char *src, int dst_len);
void debug_print(int level, const char *fmt, ...);
void print_backtrace();

/*
#include <stdio.h>
#define	DPRINT(level, fmt, args...)	printf("%d->%s: " fmt, getpid(), __FUNCTION__, ## args)
*/

#define	DPRINT(level, fmt, args...)	debug_print(level, "%d->%s: " fmt, getpid(), __FUNCTION__, ## args)
#define	safecpy(dst, src)		safe_copy(dst, src, sizeof(dst))

#endif /* __COMMON_H__ */
