#ifndef __SMBCTX_H__
#define __SMBCTX_H__

#include <time.h>
#include <pthread.h>
#include <libsmbclient.h>
#include "list.h"

#define SMBCTX_IS_BAD		0x01
#define SMBCTX_NEEDS_CLEANUP	0x02

typedef struct{
    char		reserved[sizeof(LIST)];
    int			flags;
    int			ref_count;
    time_t		access_time;
    pthread_mutex_t	mutex;
    SMBCCTX		*ctx;
    hstring		name;
    char		data[64];
} SmbCtx;

int  SetSmbNetbiosName(const char *netbios_name);
int  SetSmbDebugLevel(int level);
int  GetSmbDebugLevel();
int  SetMaxSmbCtxCount(int count);
int  GetMaxSmbCtxCount();
int  SetSmbCtxUpdateInterval(int interval);
int  GetSmbCtxUpdateInterval();

void    AllocateSmbCtx();
void	DestroyUnusedCtx();

SmbCtx*	GetSmbCtx(const char *smbpath);
void	ReleaseSmbCtx(SmbCtx *smb);
void	LockSmbCtx(SmbCtx *smb);
void	UnlockSmbCtx(SmbCtx *smb);
void	RefreshOldSmbCtxs(time_t threashold);

#endif	/* __SMBCTX_H__ */
